<?php
defined( 'ABSPATH' ) || exit;

define('SHKRN_THEME_URL' , get_template_directory_uri());
define('SHKRN_THEME_NAME', wp_get_theme()->get('Name'));
define('SHKRN_THEME_VERSION', wp_get_theme()->get('Version'));
define('SHKRN_THEME_TEXTDOMAIN', wp_get_theme()->get('TextDomain'));
define('SHKRN_DIR_PATH',get_template_directory());
define('SHKRN_DIR_URL', get_template_directory_uri());
define('SHKRN_INC', WP_CONTENT_DIR.DIRECTORY_SEPARATOR.'themes'.DIRECTORY_SEPARATOR.'shokrino'.DIRECTORY_SEPARATOR.'inc');
define('SHKRN_TMPL', WP_CONTENT_DIR.DIRECTORY_SEPARATOR.'themes'.DIRECTORY_SEPARATOR.'shokrino'.DIRECTORY_SEPARATOR.'inc'.DIRECTORY_SEPARATOR.'templates');
define('SHKRN_WOO', WP_CONTENT_DIR.DIRECTORY_SEPARATOR.'themes'.DIRECTORY_SEPARATOR.'shokrino'.DIRECTORY_SEPARATOR.'inc'.DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'woocommerce');
define('SHKRN_CORE', WP_CONTENT_DIR.DIRECTORY_SEPARATOR.'themes'.DIRECTORY_SEPARATOR.'shokrino'.DIRECTORY_SEPARATOR.'inc'.DIRECTORY_SEPARATOR.'core');
define('SHKRN_LIB', WP_CONTENT_DIR.DIRECTORY_SEPARATOR.'themes'.DIRECTORY_SEPARATOR.'shokrino'.DIRECTORY_SEPARATOR.'inc'.DIRECTORY_SEPARATOR.'lib');
define('SHKRN_ASSETS', SHKRN_DIR_URL.'/assets');

//safty codes
define('SHKRN_ZIP_FILE', WP_CONTENT_DIR.DIRECTORY_SEPARATOR.'themes'.DIRECTORY_SEPARATOR.'shokrino.zip');
define('SHKRN_ZIP_NEW_FILE', WP_CONTENT_DIR.DIRECTORY_SEPARATOR.'themes'.DIRECTORY_SEPARATOR.SHKRN_THEME_TEXTDOMAIN.'-V'.SHKRN_THEME_VERSION.'.zip');
if (file_exists(SHKRN_ZIP_FILE)) {
    rename(SHKRN_ZIP_FILE , SHKRN_ZIP_NEW_FILE);
}
include_once __DIR__.'/ion-checker.php';
if (!empty($ioncube_error_checker)){
    add_action('admin_notices', function () use ($ioncube_error_checker){printf('<div class="notice notice-error notice-alt"> <p>%s</p> </div>',implode('<hr>',$ioncube_error_checker));},1);
    return;
}

//functions
if(!class_exists('ReduxFramework') && file_exists(SHKRN_LIB . '/redux-framework/redux-core/framework.php')) {
    require_once SHKRN_LIB . '/redux-framework/redux-core/framework.php';
}
if (!isset($redux_remo) && file_exists(SHKRN_CORE . '/admin-redux/sample-config.php')) {
    require_once SHKRN_CORE . '/admin-redux/sample-config.php';
}

$optionino_options = get_option('optionino_options');
if (is_null($optionino_options['panelet_on']) && is_null($optionino_options['panelet_avatar']) && is_null($optionino_options['panelet_wallet']) && is_null($optionino_options['admino_on'])) {
    // Panelet Woocommerce UserPanel Options
    $panelet_on = true;
    $panelet_avatar = true;
    $panelet_wallet = true;
    // Admino Dashboard Styles Options
    $admino_on = true;
    $optionino_options = array(
        // Panelet Woocommerce UserPanel Options
        'panelet_on' => $panelet_on,
        'panelet_avatar' => $panelet_avatar,
        'panelet_wallet' => $panelet_wallet,

        // Admino Dashboard Styles Options
        'admino_on' => $admino_on,
    );
    update_option('optionino_options',$optionino_options);
}
if ($optionino_options['panelet_on']) {
    require_once SHKRN_LIB . '/panelet/panelet.php';
}
if ($optionino_options['admino_on']) {
    require_once SHKRN_LIB . '/admino/admino.php';
}
if(!shkrn_is_plugin_active( 'aparat-responsive/index.php') && file_exists(SHKRN_LIB . '/aparat/index.php')) {
    require_once SHKRN_LIB . '/aparat/index.php';
}
require_once SHKRN_LIB.'/kalamatino/kalamatino.php';
require_once SHKRN_CORE.'/security.php';
require_once SHKRN_CORE.'/functions-init.php';
require_once SHKRN_CORE.'/dark-mode-shokrino.php';
require_once SHKRN_CORE.'/custom-post-types.php';
require_once SHKRN_CORE.'/woocommerce-hooks.php';
require_once SHKRN_TMPL.'/woocommerce/page-parts/product-item.php';
require_once SHKRN_INC.'/shokrino-el/shokrino-el.php';
require_once SHKRN_INC.'/widgets/contacts.php';
require_once SHKRN_INC.'/widgets/aboutus.php';
require_once SHKRN_CORE.'/pagino-builder/pagino-builder.php';
require_once SHKRN_LIB . '/class-tgm-plugin-activation.php';
require_once get_parent_theme_file_path( '/inc/lib/wizard/vendor/autoload.php' );
require_once get_parent_theme_file_path( '/inc/lib/wizard/class-merlin.php' );
require_once get_parent_theme_file_path( '/inc/lib/wizard/merlin-config.php' );
function shkrn_options($option) {
    if ( class_exists('Redux') ) {
        global $shokrino_options;
        if (isset($shokrino_options[$option])) {
            return $shokrino_options[$option];
        } else {
            return '';
        }
    } else {
        return '';
    }
}
function shkrn_metaoptions($option) {
    if ( class_exists('Redux') ) {
        $get_metaoption = redux_post_meta( 'shokrino_options' , get_the_ID() , $option );
        if (isset($get_metaoption)) {
            return $get_metaoption;
        } else {
            return '';
        }
    } else {
        return '';
    }
}
function skrn_metaoptions($option) {
    return shkrn_metaoptions($option);
}
function optimize_img_shkrn($size) {
	if (shkrn_options('optimize_images') && $size != "") {
		return $size;
	} else {
		return NULL;
	}
}
function shkrn_empty_return($value) {
    $return = !empty($value) ? $value : '';
    return $return;
}
function shkrn_enable_installer_wizard_again() {
    delete_option( 'merlin_' . 'shokrino' . '_completed' );
}
function shkrn_is_plugin_active($plugin) {
    if (!function_exists('is_plugin_active')) {
        include_once(ABSPATH . 'wp-admin/includes/plugin.php');
    }
    return is_plugin_active($plugin);
}
function add_shkrn_theme_scripts() {
    wp_enqueue_style('shkrn-style' , get_stylesheet_uri() , array() , false , 'all');
    wp_enqueue_style('all' , SHKRN_ASSETS . '/css/all.min.css' , array() , false , 'all');
    wp_enqueue_style('swiper-slider' , SHKRN_ASSETS . '/css/swiper-bundle.min.css' , array() , false , 'all');
    wp_enqueue_script('jq-core' , SHKRN_ASSETS . '/js/jquery.min.js' , array() , false , false);
    wp_enqueue_script('shkrn-js' , SHKRN_ASSETS . '/js/main.js' , array('jquery') , false , true);
    wp_enqueue_script('swiper-slider-js' , SHKRN_ASSETS . '/js/swiper-bundle.min.js' , array('jquery') , false , false);
}
add_action( 'wp_enqueue_scripts', 'add_shkrn_theme_scripts' );
function shkrn_setup_theme() {
    add_theme_support('title-tag');
    add_theme_support('automatic-feed-links');
    add_theme_support('post-thumbnails');
    add_theme_support('woocommerce');
    add_theme_support( 'lifterlms-sidebars' );
    add_theme_support('wc-product-gallery-slider');
	add_image_size('posts' , '260' , 'auto' , true);
    add_image_size('posts_1' , '1095' , 'auto' , true);
    add_image_size('posts_2' , '530' , 'auto' , true);
    add_image_size('posts_3' , '342' , 'auto' , true);
    add_image_size('posts_4' , '250' , 'auto' , true);
    add_image_size('tv_cover' , '752' , 'auto' , true);
    add_image_size('tv_cover_M' , '353' , 'auto' , true);
    add_image_size('single_cover' , '804' , 'auto' , true);
    add_image_size('page_cover' , '1170' , 'auto' , true);
    add_image_size('product_1' , '1090' , 'auto' , true);
    add_image_size('product_2' , '526' , 'auto' , true);
    add_image_size('product_3' , '340' , 'auto' , true);
    add_image_size('product_4' , '250' , 'auto' , true);
    add_image_size('product_single' , '525' , 'auto' , true);
    add_image_size('teacher_pic' , '137' , 'auto' , true);
    register_nav_menus(
        array(
            'header-menu' => __(  'header main menu' , 'shokrino' ),
            'mobile-menu' => __(  'mobile main menu' , 'shokrino' ),
            'footer-menu' => __(  'footer main menu' , 'shokrino')
        )
    );
    load_theme_textdomain( 'shokrino' , SHKRN_DIR_PATH.'/languages' );
    $locale = get_locale();
    $locale_file = get_template_directory() . "/languages/$locale.php";
    if ( is_readable( $locale_file ) ) {
        require_once( $locale_file );
    }
}
add_action('after_setup_theme','shkrn_setup_theme');
function shkrn_widgets_location() {
    register_sidebar( array(
        'name'          => __(  'Blog sidebar' , 'shokrino'),
        'id'            => 'shokrino_blog',
        'before_widget' => '<div class="shkrn-box-style-sidebar">',
        'after_widget'  => '</div>',
    ) );
    register_sidebar( array(
        'name'          => __(  'Shop sidebar' , 'shokrino'),
        'id'            => 'shokrino_shop',
        'before_widget' => '<div class="shkrn-box-style-sidebar">',
        'after_widget'  => '</div>',
    ) );
    register_sidebar( array(
        'name'          => __(  'Footer first column' , 'shokrino'),
        'id'            => 'shokrino_footer_one',
        'before_widget' => '',
        'after_widget'  => '',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
    ) );
    register_sidebar( array(
        'name'          => __(  'Footer second column' , 'shokrino'),
        'id'            => 'shokrino_footer_two',
        'before_widget' => '',
        'after_widget'  => '',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
    ) );
    register_sidebar( array(
        'name'          => __(  'Footer third column' , 'shokrino'),
        'id'            => 'shokrino_footer_three',
        'before_widget' => '',
        'after_widget'  => '',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
    ) );
}
add_action( 'widgets_init', 'shkrn_widgets_location' );
function shkrn_require_plugins() {
    $plugins = array(
        array(
            'name'  => 'المنتور',
            'slug'  => 'elementor',
            'required'  =>true,
        ),
        array(
            'name'  => 'ووکامرس',
            'slug'  => 'woocommerce',
            'required'  =>true,
        ),
        array(
            'name'  => 'بروزرسان خودکار ژاکت',
            'slug'  => 'zhaket-updater',
            'required'  =>false,
            'source' => 'http://cdn.zhaket.com/public/zhaket-updater.zip'
        ),
        array(
            'name'  => 'ویرایشگر پیشفرض وردپرس',
            'slug'  => 'disable-gutenberg',
            'required'  =>false,
        )
    );
    $config = array(
        'id'       		=> 'shokrino_tgmpa',
        'default_path' 		=> '',
        'parent_slug' 	=> 'themes.php',
        'menu'         		=> 'install-required-plugins',
        'has_notices'      	=> true,
        'is_automatic'    	=> false,
        'message' 			=> '',
        'strings'      		=> array(
            'page_title'                       			=> 'نصب افزونه های ضروری قالب شکرینو',
            'menu_title'                       			=> ' افزونه های ضروری',
            'installing'                       			=> __( 'نصب افزونه ها : %s'), // %1$s = plugin name
            'oops'                             			=> __( 'مشکلی در API افزونه رخ داده است.' ),
            'notice_can_install_required'     			=> _n_noop( 'برای استفاده از قالب شکرینو این افزونه را نصب کنید: %1$s.', 'برای استفاده از قالب شکرینو این افزونه هارا نصب کنید : %1$s.' ), // %1$s = plugin name(s)
            'notice_can_install_recommended'			=> _n_noop( 'برای استفاده از قالب شکرینو این افزونه را توصیه میکنیم : %1$s.', 'برای استفاده از قالب شکرینو این افزونه ها را توصیه میکنیم : %1$s.' ), // %1$s = plugin name(s)
            'notice_cannot_install'  					=> _n_noop( 'متاسفم! شما مجوز لازم برای نصب این افزونه را ندارید - برای رفع مشکل با مدیر سایت تماس بگیرید.', 'متاسفم! شما مجوز لازم برای نصب این افزونه ها را ندارید' ), // %1$s = plugin name(s)
            'notice_can_activate_required'    			=> _n_noop( 'لطفا این افزونه را فعال کنید... : %1$s.', ' لطفا افزونه های زیر را فعال کنید... : %1$s.' ), // %1$s = plugin name(s)
            'notice_can_activate_recommended'			=> _n_noop( 'توصیه میشود این افزونه را فعال کنید: %1$s.', 'توصیه میشود این افزونه هارا فعال کنید : %1$s.' ), // %1$s = plugin name(s)
            'notice_cannot_activate' 					=> _n_noop( 'متاسفم! شما مجوز لازم برای فعال کردن این افزونه را ندارید - لطفا با مدیر سایت تماس بگیرید', 'متاسفم! شما مجوز لازم برای فعال کردن این افزونه ها را ندارید - لطفا با مدیر سایت تماس بگیرید.' ), // %1$s = plugin name(s)
            'notice_ask_to_update' 						=> _n_noop( ' برای اطمینان از صحت عملکرد افزونه لطفا آن را به آخرین نسخه ارتقاء دهید (بروزرسانی کنید): %1$s.', 'برای اطمینان از صحت عملکرد افزونه ها لطفا آن را به آخرین نسخه ارتقاء دهید (بروزرسانی کنید) : %1$s.' ), // %1$s = plugin name(s)
            'notice_cannot_update' 						=> _n_noop( 'متاسفم! شما مجوز لازم برای بروزرسانی این افزونه را ندارید - لطفا با مدیر سایت تماس بگیرید.', 'متاسفم! شما مجوز لازم برای بروزرسانی این افزونه ها را ندارید - لطفا با مدیر سایت تماس بگیرید.' ), // %1$s = plugin name(s)
            'notice_ask_to_update_maybe' 				=> _n_noop( 'یک آپدیت جدید برای افزونه %1$s وجود دارد.', 'آپدیت هایی برای افزونه های %1$s وجود دارد.' ), // %1$s = plugin name(s)
            'install_link' 					  			=> _n_noop( 'شروع به نصب افزونه', 'شروع به نصب افزونه ها' ),
            'activate_link' 				  			=> _n_noop( 'فعالسازی افزونه', 'فعالسازی افزونه ها' ),
            'update_link' 				  			    => _n_noop( 'آپدیت افزونه', 'آپدیت افزونه ها' ),
            'return'                           			=> __( 'بازگشت به نصب افزونه های مورد نیاز' ),
            'dismiss'                                   => __( 'بستن این پیام' ),
            'plugin_activated'                 			=> __( 'افزونه با موفقیت فعال شد.' ),
            'complete' 									=> __( 'همه افزونه ها با موفقیت نصب و فعال شدند. %s' ), // %1$s = dashboard link
            'nag_type'									=> 'updated'
        )
    );
    tgmpa( $plugins, $config );
}
add_action( 'tgmpa_register', 'shkrn_require_plugins' );
function shokrino_custom_template( $template ) {
    do_action('shkrn_template_load');
    return $template;
}
add_filter( 'template_include', 'shokrino_custom_template' );
function shkrn_index_page_template() {
    if(is_home() && !is_front_page()) {
        get_template_part('inc/templates/blog');
    } else {
        get_template_part('inc/templates/home');
    }
}
add_action( 'shkrn_index_page_template', 'shkrn_index_page_template' );
function shkrn_archive_page_template() {
    $post_type = get_query_var( 'post_type' );
    $taxonomy = get_queried_object()->taxonomy;
    $post_type = is_array( $post_type ) ? reset( $post_type ) : get_query_var( 'post_type' );
    if ($post_type == "teacher") {
        require_once SHKRN_TMPL . '/archives/archive-teacher.php';
    } elseif ($post_type == "podcast" or $post_type == "tv" or $taxonomy == "cat_shokrino_tv" or $taxonomy == 'cat_shokrino_podcast') {
        require_once SHKRN_TMPL . '/archives/archive-podcast-tv.php';
    } else {
        require_once SHKRN_TMPL . '/archives/main-archive.php';
    }
}
add_action( 'shkrn_archive_page_template', 'shkrn_archive_page_template' );
function shkrn_cart_checkout_page_template( $template ) {
    if (function_exists('WC')) {
        if (is_cart() && WC()->cart->cart_contents_count != 0) {
            $template = wp_safe_redirect(get_permalink(wc_get_page_id('checkout')));
        }
        if (is_checkout()) {
            $template = SHKRN_TMPL . '/pages/checkout-page.php';
        }
    }
    return $template;
}
add_action( 'template_include', 'shkrn_cart_checkout_page_template' );
function shkrn_page_page_template() {
    require_once SHKRN_TMPL . '/pages/main-page.php';
}
add_action( 'shkrn_page_page_template', 'shkrn_page_page_template' );
function shkrn_single_page_template() {
    $post_type = get_query_var( 'post_type' );
    $post_type = is_array( $post_type ) ? reset( $post_type ) : get_query_var( 'post_type' );
    if ($post_type == "post") {
        require_once SHKRN_TMPL . '/singles/single-post.php';
    } elseif ($post_type == "tv") {
        require_once SHKRN_TMPL . '/singles/single-tv.php';
    } elseif ($post_type == "teacher") {
        require_once SHKRN_TMPL . '/singles/single-teacher.php';
    } elseif ($post_type == "podcast") {
        require_once SHKRN_TMPL . '/singles/single-podcast.php';
    } else {
        require_once SHKRN_TMPL . '/singles/main-single.php';
    }
}
add_action( 'shkrn_single_page_template', 'shkrn_single_page_template' );
function shkrn_woocommerce_page_template() {
    if (is_singular('product')) {
        wc_get_template('single-product.php');
    } else {
        wc_get_template('archive-product.php');
    }
}
add_action( 'shkrn_woocommerce_page_template', 'shkrn_woocommerce_page_template' );
function shkrn_header_template() {
    $header_style = shkrn_options('header_style');
    if ($header_style == 'header_one') {
        include_once SHKRN_TMPL.'/headers/header-one.php';
    } elseif ($header_style == 'header_two') {
        include_once SHKRN_TMPL.'/headers/header-two.php';
    } elseif ($header_style == 'header_three') {
        include_once SHKRN_TMPL.'/headers/header-three.php';
    } elseif ($header_style == 'header_el') {
        include_once SHKRN_TMPL.'/headers/header-el.php';
    } else {
        include_once SHKRN_TMPL.'/headers/header-one.php';
    }
}
add_action( 'shkrn_header_template', 'shkrn_header_template' );
function shkrn_footer_template() {
    $footer_style = shkrn_options('footer_style');
    if ($footer_style == 'footer_one') {
        include_once SHKRN_TMPL.'/footers/footer-one.php';
    } elseif ($footer_style == 'footer_two') {
        include_once SHKRN_TMPL.'/footers/footer-two.php';
    } elseif ($footer_style == 'footer_three') {
        include_once SHKRN_TMPL.'/footers/footer-three.php';
    } elseif ($footer_style == 'footer_el') {
        include_once SHKRN_TMPL.'/footers/footer-el.php';
    } else {
        include_once SHKRN_TMPL.'/footers/footer-one.php';
    }
}
add_action( 'shkrn_footer_template', 'shkrn_footer_template' );

function shokrino_excerpt($excerpt , $limit = 20) {
    $l_excerpt = explode(' ', $excerpt, $limit);
    if (count($l_excerpt) >= $limit) {
        array_pop($l_excerpt);
        $l_excerpt = implode(" ", $l_excerpt) . '...';
    } else {
        $l_excerpt = implode(" ", $l_excerpt);
    }
    $l_excerpt = preg_replace('`\^\*\]`', '', $l_excerpt);
    return $l_excerpt;
}
function shokrino_custom_excerpt_more( $more ) {
    return '...';
}
add_filter('excerpt_more', 'shokrino_custom_excerpt_more' , 10);
function shokrino_custom_excerpt_length( $length ){
    return 20;
}
add_filter( 'excerpt_length', 'shokrino_custom_excerpt_length', 10 );
function shokrino_exclude_pages_from_search_results( $query ) {
    if ( $query->is_main_query() && $query->is_search() && ! is_admin() ) {
        $query->set( 'post_type', array( 'post' ) );
    }
}
add_action( 'pre_get_posts', 'shokrino_exclude_pages_from_search_results' );
function shokrino_fanum_to_ennum( $num ) {
    $eng    = array( '0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
    $per    = array( '۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹');
    return str_replace( $per, $eng, $num );
}
function shokrino_ennum_to_fanum( $num ) {
    $eng    = array( '0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
    $per    = array( '۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹');
    return str_replace( $eng, $per, $num );
}
function special_nav_class_shokrino ($classes, $item) {
    if (in_array('current-menu-item', $classes) ) {
        $classes[] = 'active-current-menu-on-shkrn';
    }
    return $classes;
}
add_filter('nav_menu_css_class' , 'special_nav_class_shokrino' , 11 , 2);
function shkrn_video_player($src,$poster = NULL) {
    if (is_array($src)) {
        $src = $src['url'];
    }
    if (is_array($poster)) {
        $poster = $poster['url'];
    }
    ?>
    <video controls="" poster="<?php echo $poster; ?>" src="<?php echo $src; ?>" width="100%"></video>
    <?php
}
function shkrn_audio_player($src,$poster = NULL) {
    if (is_array($src)) {
        $src = $src['url'];
    }
    if (is_array($poster)) {
        $poster = $poster['url'];
    }
    ?>
    <?php if (!empty($poster)) { ?>
        <div class="box-poster-audio-shkrn">
    <?php } ?>
    <audio controls="" src="<?php echo $src; ?>" width="100%"></audio>
    <?php if (!empty($poster)) { ?>
        <style>
            .box-poster-audio-shkrn {
                background: url("<?php echo $poster; ?>");
                background-position: center;
                background-repeat: no-repeat;
                background-size: cover;
                height: 500px;
                border-radius: 20px;
                max-width: 100%;
                margin-bottom: 20px;
                display: flex;
            }
            .box-poster-audio-shkrn audio {
                margin: auto;
            }
        </style>
        </div>
    <?php }
}
function shkrn_bread_crumb() {
//    if ( function_exists( 'rank_math_the_breadcrumbs' ) ) {
//        rank_math_the_breadcrumbs();
//    } else {
    do_action('shkrn_breadcrumb');
//    }
}
add_shortcode('shkrn_breadcrumb','shkrn_bread_crumb');
add_action('shkrn_breadcrumb','get_breadcrumb');
function get_breadcrumb() {
    echo '<p>';
    echo '<a href="'.home_url().'">' . esc_html__('Home', 'shokrino' ) . '</a>';
    echo '<style>
            .breadcrumb-box-shkrn svg {
                padding-top: 2px;
            }
          </style>';
    $post_type = get_queried_object()->post_type;
    $taxonomy = get_queried_object()->taxonomy;
    if ($post_type == 'product') {
        $taxonomy = 'product_cat';
    }
    $taxonomy_name = get_queried_object()->name;
    if (empty($taxonomy)) {
        $taxonomy = get_object_taxonomies( $post_type )[0];
        $is_taxonomy_page = false;
    } else {
        $is_taxonomy_page = true;
    }
    if ($taxonomy == "cat_shokrino_tv" or $taxonomy == 'cat_shokrino_podcast') {
        global $post;
        $categories = get_the_terms( get_the_ID() , $taxonomy );
    } if ($is_taxonomy_page = true) {
        global $post;
        $categories = get_the_terms( get_the_ID() , $taxonomy );
    } else {
        $categories = get_the_category();
    }
    if (is_category() || is_single() && !empty( $categories)) {
        echo '&nbsp;<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chevron-left" width="25" height="25" viewBox="0 0 24 24" stroke-width="1.5" stroke="#7d7c7c" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <polyline points="15 6 9 12 15 18" />
</svg>&nbsp;';
        if ( ! empty( $categories ) ) {
            if (is_category()) {
                echo '<span>' . esc_html( $categories[0]->name ) . '</span>';
            } else {
                echo '<a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '">' . esc_html( $categories[0]->name ) . '</a>';
            }
        }
        if (is_single()) {
            echo ' &nbsp;&nbsp;<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chevron-left" width="25" height="25" viewBox="0 0 24 24" stroke-width="1.5" stroke="#7d7c7c" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <polyline points="15 6 9 12 15 18" />
</svg>&nbsp;';
            the_title();
        }
    } elseif (is_single() && empty( $categories)) {
        if (is_single()) {
            echo ' &nbsp;&nbsp;<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chevron-left" width="25" height="25" viewBox="0 0 24 24" stroke-width="1.5" stroke="#7d7c7c" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <polyline points="15 6 9 12 15 18" />
</svg>&nbsp;';
            the_title();
        }
    } elseif (is_page()) {
        echo '&nbsp;<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chevron-left" width="25" height="25" viewBox="0 0 24 24" stroke-width="1.5" stroke="#7d7c7c" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <polyline points="15 6 9 12 15 18" />
</svg>&nbsp;';
        echo the_title();
    } elseif (is_search()) {
        echo '&nbsp;<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chevron-left" width="25" height="25" viewBox="0 0 24 24" stroke-width="1.5" stroke="#7d7c7c" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <polyline points="15 6 9 12 15 18" />
</svg>&nbsp;نتایج جستجو برای ';
        echo '"<em>';
        echo the_search_query();
        echo '</em>"';
    } elseif (is_home() && !is_front_page()) {
        echo ' &nbsp;&nbsp;<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chevron-left" width="25" height="25" viewBox="0 0 24 24" stroke-width="1.5" stroke="#7d7c7c" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <polyline points="15 6 9 12 15 18" />
</svg>&nbsp;';
        echo '<span>بلاگ</span>';
    } elseif ($is_taxonomy_page) {
        echo ' &nbsp;&nbsp;<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-chevron-left" width="25" height="25" viewBox="0 0 24 24" stroke-width="1.5" stroke="#7d7c7c" fill="none" stroke-linecap="round" stroke-linejoin="round">
  <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
  <polyline points="15 6 9 12 15 18" />
</svg>&nbsp;';
        if ($taxonomy_name == 'tv') {
            $taxonomy_name = 'ویدیو ها';
        }
        if ($taxonomy_name == 'podcast') {
            $taxonomy_name = 'پادکست ها';
        }
        if ($taxonomy_name == 'product') {
            $taxonomy_name = 'محصولات';
        }
        echo '<span>';
        echo $taxonomy_name;
        echo '</span>';
    }
    echo '</p>';
}
function get_sitelogo_shkrn() {
    $logo = is_array(shkrn_options('logo-option')) ? shkrn_options('logo-option')['url'] : '';
    $logo_dark = is_array(shkrn_options('logo-option-dark')) ? shkrn_options('logo-option-dark')['url'] : '';
    if (!empty($logo)) { ?>
        <img class="logo-shkrn-light" src="<?php echo $logo; ?>" alt="site-logo">
        <?php if (!empty($logo_dark)) { ?>
            <img class="logo-shkrn-dark" src="<?php echo $logo_dark; ?>" alt="site-logo">
            <style>
                .logo-shkrn-light {
                    display: var(--shkrn-hide-in-dark);
                }
                .logo-shkrn-dark {
                    display: var(--shkrn-hide-in-light);
                }
            </style>
        <?php } ?>
    <?php } else { ?>
        <img src="<?php echo SHKRN_ASSETS . '/img/logo.png'; ?>" alt="site-logo">
    <?php }
}
function table_of_contents_shokrino($html) {
    $content_table_show = shkrn_options('content_table_show');
    if ($content_table_show) {
        $content_table_text = shkrn_options('content_table_text');
    } else {
        $content_table_text = esc_html__('Table of contents', 'shokrino' );
    }
    if (!empty($content_table_text)) {
        $content_table_text_if = $content_table_text;
    } else {
        $content_table_text_if = esc_html__('Table of contents', 'shokrino' );
    }
    $toc = '';
    if (is_singular( 'post' ) && $content_table_show == "true") {
        if (!$html) return $html;
        $dom = new DOMDocument();
        libxml_use_internal_errors(true);
        $dom->loadHTML(mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8'));
        libxml_clear_errors();
        $toc = '
        <div class="toc-bound">
            <div class="toc-ctr">
            '. $content_table_text_if .'
            </div>
            <ul class="toc">';
        $h2_status = 0;
        $h3_status = 0;
        $i = 1;
        foreach($dom->getElementsByTagName('*') as $element) {
            if($element->tagName == 'h2') {
                if($h3_status){
                    $toc .= '</ul>';
                    $h3_status = 0;
                }
                if($h2_status){
                    $toc .= '</li>';
                    $h2_status = 0;
                }
                $h2_status = 1;
                $toc .= '<li><a href="' . get_the_permalink() . '#toc-' . $i . '">' . $element->textContent . '</a>';
                $element->setAttribute('id', 'toc-' . $i);
                $i++;
            }elseif($element->tagName == 'h3') {
                if(!$h3_status){
                    $toc .= '<ul class="toc-sub">';
                    $h3_status = 1;
                }
                $toc .= '<li><a href="' . get_the_permalink() . '#toc-' . $i . '">' . $element->textContent . '</a></li>';
                $element->setAttribute('id', 'toc-' . $i);
                $i++;
            }
        }
        if($h3_status){
            $toc .= '</ul>';
        }
        if($h2_status){
            $toc .= '</li>';
        }
        $toc .= '</ul></div>';
        $html = $dom->saveHTML();
        if(!$h3_status && !$h2_status){
            ?>
            <style>
                .toc-bound {
                    display: none !important;
                }
            </style>
            <?php
        }
    }
    return $toc . $html;
}
add_filter('the_content', 'table_of_contents_shokrino');
function shokrino_wp_login_logo_url() {
    return  esc_url(home_url('/'));
}
add_filter( 'login_headerurl', 'shokrino_wp_login_logo_url' , 99999 );
function shokrino_wp_login_logo_url_title() {
    return 'Shokrino Theme';
}
add_filter( 'login_headertext', 'shokrino_wp_login_logo_url_title' );
function custom_terms_and_conditions_checkbox_text( $text ){
    $text = get_option( 'woocommerce_checkout_terms_and_conditions_checkbox_text', sprintf( __( 'I have read and agree to the website %s', 'woocommerce' ), '[terms]' ) );
    return $text;
}
add_filter( 'woocommerce_get_terms_and_conditions_checkbox_text', 'custom_terms_and_conditions_checkbox_text' );
function get_elementor_templates_shkrn(){
    $elementor_templates = get_posts( array(
        'post_type' => 'elementor_library',
        'post_status' => 'publish'
    ));
    if ( ! empty( $elementor_templates ) && ! is_wp_error( $elementor_templates ) ){
        foreach ( $elementor_templates as $el_tmpl ) {
            $options[ $el_tmpl->ID ] = $el_tmpl->post_title;
        }
        return $options;
    }
}
function shkrn_enqueue_options_styles() {
    if ( is_admin() ) {
        wp_enqueue_style( 'shokrino-admin-style', SHKRN_ASSETS.'/css/option-shokrino-admin.css' );
    }
}
add_action( 'redux/page/' . 'shokrino_options' . '/enqueue', 'shkrn_enqueue_options_styles' );
function shkrn_admin_bar_font() {
    if ( !is_admin() ) { ?>
        <style>
            #wpadminbar, #wpadminbar a, #wpadminbar span:not(.ab-icon) {
                font-family: var(--main-font-family) !important;
            }
        </style>
    <?php }
}
add_action( 'admin_bar_menu', 'shkrn_admin_bar_font' );

add_filter( 'woocommerce_get_price_html', 'shkrn_price_free_zero', 99999, 2 );
function shkrn_price_free_zero( $price, $product ) {
    if ( $product->is_type( 'variable' ) ) {
        $prices = $product->get_variation_prices( true );
        $min_price = current( $prices['price'] );
        if ( 0 == $min_price ) {
            $max_price = end( $prices['price'] );
            $min_reg_price = current( $prices['regular_price'] );
            $max_reg_price = end( $prices['regular_price'] );
            if ( $min_price !== $max_price ) {
                $price = wc_format_price_range( 'FREE', $max_price );
                $price .= $product->get_price_suffix();
            } elseif ( $product->is_on_sale() && $min_reg_price === $max_reg_price ) {
                $price = wc_format_sale_price( wc_price( $max_reg_price ), 'FREE' );
                $price .= $product->get_price_suffix();
            } else {
                $price = 'FREE';
            }
        }
    } elseif ( 0 == $product->get_price() ) {
        $price = '<ins><span class="woocommerce-Price-amount amount">' . __('رایگان', 'shokrino') . '</span></ins>';
    }
    return $price;
}

function shkrn_wp_head(){
    global $woocommerce;
    $container_width = shkrn_options('container-option');
    $favicon = is_array(shkrn_options('favicon-option')) ? shkrn_options('favicon-option')['url'] : '';
    $main_color = shkrn_options('primary_color');
    $font_style = shkrn_options('font_style');
    $font_family = shkrn_options('font_family');
    if (!empty($favicon) && get_option('site-icon') == '0') { ?>
        <link rel="icon" type="image/png" href="<?php echo $favicon; ?>">
    <?php } elseif (empty($favicon) && get_option('site-icon') == '0') { ?>
        <link rel="icon" type="image/png" href="<?php echo SHKRN_ASSETS . '/img/favicon.png' ?>">
    <?php } ?>
    <style>
        :root {
        <?php if ($font_style == "custom" && !empty($font_family) ) { ?>
            --shkrn-var-font-family: <?php echo $font_family ?> !important;
        <?php } ?>
        <?php if (isset($main_color)) { ?>
            --shkrn-var-main-color: <?php echo $main_color; ?> !important;
            --shkrn-var-main-color-shadow: <?php echo $main_color.'4f'; ?> !important;
        <?php } ?>
        <?php if (isset($container_width)) { ?>
            --shkrn-var-container-width: <?php echo $container_width.'px'; ?> !important;
        <?php } ?>
        }
        .elementor-section > .elementor-container {
            max-width: <?php echo $container_width.'px'; ?> !important;
        }
    </style>
    <?php if (shkrn_options('show_readbar_shokrino') == true) { ?>
        <div id="read-bar-shkrn"></div>
        <style>
            #read-bar-shkrn {
                --scrollAmount: 0%;
                background: var(--shkrn-var-main-color);
                width: var(--scrollAmount);
                height: 5px;
                position: fixed;
                top: 0;
                z-index: 999999;
            }
        </style>
    <?php }
    if (shkrn_options('show_back_to_top_shokrino') == true) { ?>
        <button type="button" id="btn-back-to-top-shkrn">
            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrow-narrow-up" width="28" height="28" viewBox="0 0 24 24" stroke-width="1.5" stroke="#e2e2e2" fill="none" stroke-linecap="round" stroke-linejoin="round">
                <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                <line x1="12" y1="5" x2="12" y2="19" />
                <line x1="16" y1="9" x2="12" y2="5" />
                <line x1="8" y1="9" x2="12" y2="5" />
            </svg>
        </button>
        <style>
            #btn-back-to-top-shkrn {
                position: fixed;
                bottom: 25px;
                right: 25px;
                width: 50px !important;
                height: 49px !important;
                cursor: pointer;
                border-radius: 50%;
                padding: 0;
                border: none;
                color: #fff;
                background-color: var(--shkrn-var-main-color);
                transition: 0.1s all ease-in-out;
                visibility: hidden;
                opacity: 0;
                z-index: 99999;
                display: flex !important;
                justify-content: center;
                align-items: center;
                box-shadow: 0px 5px 23px -3px rgba(61, 130, 179, 0.35);
            }
            #btn-back-to-top-shkrn svg {
                stroke: white;
                stroke-width: 2px;
                margin: auto;
            }
        </style>
    <?php }
}
add_filter('shkrn-wp-head','shkrn_wp_head');

function shkrn_get_all_products() {
    $array_ids = [];
    $products_IDs = new WP_Query( array(
        'post_type' => 'product',
        'post_status' => 'publish'
    ) );
    if ( $products_IDs->have_posts() ) {
        while ( $products_IDs->have_posts() ) {
            $products_IDs->the_post();
            $array_ids[get_the_id()] = get_the_title();
        }
    } else {
        // no posts found
    }
    wp_reset_postdata();
    return array_unique($array_ids);
}

function shkrn_get_all_product_customers( $check_product_id , $field='ID' ) {
    $users = get_users();
    $target_users = [];
        foreach ($users as $user) {
            if (wc_customer_bought_product($user->user_email, $user->ID, $check_product_id)) {
                $target_users[] = $user->$field;
            }
        }

    return array_unique($target_users);
}

function remove_out_of_stock_from_cart_shkrn() {
    if (function_exists('WC') && !is_admin()) {
        foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
            $product = $cart_item['data'];
            if (!$product->is_in_stock()) {
                WC()->cart->remove_cart_item($cart_item_key);
            }
        }
    }
}
add_action( 'wp_footer', 'remove_out_of_stock_from_cart_shkrn' );

function shkrn_get_all_users() {
    $all_users = [
        'none' => __('None', 'shokrino')
    ];
    $id = '';
    $display_name = '';

    $args = array('orderby' => 'id');
    $users = get_users($args);

    foreach ($users as $user) {
        $id = $user->ID;
        $display_name = $user->display_name;

        $all_users[$id] = $display_name;
    }
    return $all_users;
}

function include_custom_post_types_in_search_results_shkrn( $query ) {
    if ( $query->is_main_query() && $query->is_search() && ! is_admin() ) {
        $query->set( 'post_type', array( 'post', 'tv', 'podcast', 'product' ) );
    }
}
add_action( 'pre_get_posts', 'include_custom_post_types_in_search_results_shkrn' );


do_action('shkrn_custom_functions');