<?php
defined( 'ABSPATH' ) || exit;

if (!function_exists('is_plugin_active')) {
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');
}
require_once( PNLT_INC . '/admin/register_options.php' );

function pnlt_update_option($option_name,$value,$default='') {
    if (!is_bool($value) && empty($value)) {
        $value_to_set = $default;
    } elseif (is_bool($default) && !is_bool($value)) {
        $value_to_set = $default;
    } elseif (is_bool($default) && is_bool($value)) {
        $value_to_set = $value;
    } else {
        $value_to_set = $value;
    }
    $value_array = get_option('panelet_options',array('panelet'=>true));
    if (is_null($value_array[$option_name])) {
        $value_to_array = array(
            $option_name => $value_to_set,
        );
        $complete_value = array_slice($value_array,0, count($value_array))+$value_to_array;
    } else {
        $value_array[$option_name] = $value_to_set;
        $complete_value = array_slice($value_array,0, count($value_array));
    }
    update_option('panelet_options',$complete_value);
}

function panelet_options($option_name) {
    $value_array = get_option('panelet_options','');
    $value = $value_array[$option_name];
    return $value;
}

function panelet_on_plugin_loaded() {
    if (!is_array(get_option('panelet_options'))) {
        update_option('panelet_options',array('panelet'=>true));
    }
    panelet_register_options();
}
add_action( 'wp_loaded', 'panelet_on_plugin_loaded' );

