<?php
defined( 'ABSPATH' ) || exit;
?>
<div class="tab">
    <button class="tablinks" onclick="openOptionspanelet(event, 'Info')">
        <div class="panelet-tab-titles-box">
            <div class="panelet-title-tab-options">
                <?php echo __('Wallet Info', 'shokrino'); ?>
            </div>
            <div class="panelet-desc-tab-options">
                <?php echo __('get your wallet information', 'shokrino'); ?>
            </div>
        </div>
        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-info-square" width="30"
             height="30" viewBox="0 0 24 24" stroke-width="1.5" stroke="#e2e2e2" fill="none" stroke-linecap="round"
             stroke-linejoin="round">
            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
            <line x1="12" y1="8" x2="12.01" y2="8" />
            <rect x="4" y="4" width="16" height="16" rx="2" />
            <polyline points="11 12 12 12 12 16 13 16" />
        </svg>
    </button>
    <button class="tablinks" onclick="openOptionspanelet(event, 'Add')">
        <div class="panelet-tab-titles-box">
            <div class="panelet-title-tab-options">
                <?php echo __('Add balance', 'shokrino'); ?>
            </div>
            <div class="panelet-desc-tab-options">
                <?php echo __('Increase your wallet balance', 'shokrino'); ?>
            </div>
        </div>
        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-circle-plus" width="30"
             height="30" viewBox="0 0 24 24" stroke-width="1.5" stroke="#e2e2e2" fill="none" stroke-linecap="round"
             stroke-linejoin="round">
            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
            <circle cx="12" cy="12" r="9" />
            <line x1="9" y1="12" x2="15" y2="12" />
            <line x1="12" y1="9" x2="12" y2="15" />
        </svg>
    </button>
    <button class="tablinks" onclick="openOptionspanelet(event, 'Transfer')">
        <div class="panelet-tab-titles-box">
            <div class="panelet-title-tab-options">
                <?php echo __('Transfer balance', 'shokrino'); ?>
            </div>
            <div class="panelet-desc-tab-options">
                <?php echo __('Transfer balance to other users', 'shokrino'); ?>
            </div>
        </div>
        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-arrows-sort" width="30"
             height="30" viewBox="0 0 24 24" stroke-width="1.5" stroke="#e2e2e2" fill="none" stroke-linecap="round"
             stroke-linejoin="round">
            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
            <path d="M3 9l4 -4l4 4m-4 -4v14" />
            <path d="M21 15l-4 4l-4 -4m4 4v-14" />
        </svg>
    </button>
    <button class="tablinks" onclick="openOptionspanelet(event, 'Transactions')">
        <div class="panelet-tab-titles-box">
            <div class="panelet-title-tab-options">
                <?php echo __('Transactions History', 'shokrino'); ?>
            </div>
            <div class="panelet-desc-tab-options">
                <?php echo __('list of wallet Transactions', 'shokrino'); ?>
            </div>
        </div>
        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-list-check" width="30"
             height="30" viewBox="0 0 24 24" stroke-width="1.5" stroke="#e2e2e2" fill="none" stroke-linecap="round"
             stroke-linejoin="round">
            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
            <path d="M3.5 5.5l1.5 1.5l2.5 -2.5" />
            <path d="M3.5 11.5l1.5 1.5l2.5 -2.5" />
            <path d="M3.5 17.5l1.5 1.5l2.5 -2.5" />
            <line x1="11" y1="6" x2="20" y2="6" />
            <line x1="11" y1="12" x2="20" y2="12" />
            <line x1="11" y1="18" x2="20" y2="18" />
        </svg>
    </button>
</div>
<div id="save-options-panelet" class="panelet-tab-content-outer">

    <div id="Info" class="tabcontent">
        <div class="box-panelet-first-row-ballance">
            <div class="box-panelet-wallet-ballance" style="padding: 0">
                <div class="user-panel-avatar">
                    <?php
                    global $current_user;
                    wp_get_current_user();
                    $avatar_user = get_avatar($current_user->ID, 120);
                    if (!empty($avatar_user)) {
                        echo $avatar_user;
                    } else { ?>
                        <img width="100%" height="100%" src="<?php echo PNLT_ASSETS . '/img/user.jpg' ?>">
                    <?php } ?>
                </div>
            </div>
            <div class="box-panelet-wallet-ballance">
                <div class="box-icon-woo-wallet">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-wallet" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#6ab04c" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <path d="M17 8v-3a1 1 0 0 0 -1 -1h-10a2 2 0 0 0 0 4h12a1 1 0 0 1 1 1v3m0 4v3a1 1 0 0 1 -1 1h-12a2 2 0 0 1 -2 -2v-12"></path>
                        <path d="M20 12v4h-4a2 2 0 0 1 0 -4h4"></path>
                    </svg>
                </div>
                <div class="box-balance-woo-wallet">
                    <h3><?php _e('current balance:','shokrino') ?></h3>
                    <span><?php echo woo_wallet()->wallet->get_wallet_balance( get_current_user_id() ); ?></span>
                </div>
                <button class="box-add-balance-woo-wallet" onclick="openOptionspanelet(event, 'Add')">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-circle-plus" width="35"
                         height="35" viewBox="0 0 24 24" stroke-width="1.5" stroke="#00c60c" fill="none" stroke-linecap="round"
                         stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <circle cx="12" cy="12" r="9" />
                        <line x1="9" y1="12" x2="15" y2="12" />
                        <line x1="12" y1="9" x2="12" y2="15" />
                    </svg>
                </button>
            </div>
            <div class="box-panelet-wallet-ballance">
                <button class="box-add-balance-woo-wallet" onclick="openOptionspanelet(event, 'Transactions')">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-history" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="var(--shkrn-var-color-light-dark-text)" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <polyline points="12 8 12 12 14 14" />
                        <path d="M3.05 11a9 9 0 1 1 .5 4m-.5 5v-5h5" />
                    </svg>
                </button>
            </div>
        </div>
        <div class="box-panelet-second-row-ballance">
            <?php
            $current_user_id = get_current_user_id();
            $user_info = get_userdata($current_user_id);
            $display_name = $user_info->display_name;
            $user_email = $user_info->user_email;
            $first_name = $user_info->first_name;
            $last_name = $user_info->last_name;
            ?>
            <div class="box-panelet-info-title half-width-panelet">
                <span class="your-display-name-panelet"><?php _e('your Display Name','shokrino') ?></span>
                <input type="text" value="<?php echo $display_name; ?>" disabled>
            </div>
            <div class="box-panelet-info-title half-width-panelet">
                <span class="your-user-id-panelet"><?php _e('your User ID','shokrino') ?></span>
                <input type="text" value="<?php echo $current_user_id; ?>" disabled>
            </div>
            <div class="box-panelet-info-title">
                <span class="your-email-panelet"><?php _e('your email','shokrino') ?></span>
                <input type="email" value="<?php echo $user_email; ?>" disabled>
            </div>
        </div>
        <div class="box-panelet-second-row-ballance">
            <a class="btn-edit-profile-panelet-wallet" href="<?php echo esc_url(wc_get_account_endpoint_url('edit-account')); ?>">
                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-settings" width="25" height="25" viewBox="0 0 24 24" stroke-width="1.1px" stroke="#294559" fill="none" stroke-linecap="round" stroke-linejoin="round">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                    <path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z" />
                    <circle cx="12" cy="12" r="3" />
                </svg>
                <?php esc_html_e('Edit profile', 'shokrino' ); ?>
            </a>
        </div>
    </div>

    <div id="Add" class="tabcontent">
        <form method="post" action="">
            <div class="woo-wallet-add-amount">
                <label for="woo_wallet_balance_to_add"><?php _e( 'Enter amount', 'shokrino' ); ?></label>
                <p><?php _e('Enter the amount of credit you want to add to your wallet and then click the "Add" button to be taken to the payment page.','shokrino') ?></p>
                <?php
                $min_amount = woo_wallet()->settings_api->get_option( 'min_topup_amount', '_wallet_settings_general', 0 );
                $max_amount = woo_wallet()->settings_api->get_option( 'max_topup_amount', '_wallet_settings_general', '' );
                ?>
                <input type="number" step="0.01" min="<?php echo $min_amount; ?>" max="<?php echo $max_amount; ?>" name="woo_wallet_balance_to_add" id="woo_wallet_balance_to_add" class="woo-wallet-balance-to-add" required="" />
                <?php wp_nonce_field( 'woo_wallet_topup', 'woo_wallet_topup' ); ?>
                <input type="submit" name="woo_add_to_wallet" class="woo-add-to-wallet" value="<?php _e( 'Add', 'shokrino' ); ?>" />
            </div>
        </form>
    </div>

    <div id="Transfer" class="tabcontent">
        <form method="post" action="" id="woo_wallet_transfer_form">
            <p class="woo-wallet-field-container form-row form-row-wide">
                <label for="woo_wallet_transfer_user_id"><?php _e( 'Select whom to transfer', 'shokrino' ); ?> <?php
                    if ( apply_filters( 'woo_wallet_user_search_exact_match', true ) ) {
                        _e( '(Email)', 'shokrino' );
                    }
                    ?></label>
                <select name="woo_wallet_transfer_user_id" class="woo-wallet-select2" required=""></select>
            </p>
            <p class="woo-wallet-field-container form-row form-row-wide">
                <label for="woo_wallet_transfer_amount"><?php _e( 'Amount', 'shokrino' ); ?></label>
                <input type="number" step="0.01" min="<?php echo woo_wallet()->settings_api->get_option('min_transfer_amount', '_wallet_settings_general', 0); ?>" name="woo_wallet_transfer_amount" required=""/>
            </p>
            <p class="woo-wallet-field-container form-row form-row-wide">
                <label for="woo_wallet_transfer_note"><?php _e( 'What\'s this for', 'shokrino' ); ?></label>
                <textarea name="woo_wallet_transfer_note"></textarea>
            </p>
            <p class="woo-wallet-field-container form-row">
                <?php wp_nonce_field( 'woo_wallet_transfer', 'woo_wallet_transfer' ); ?>
                <input type="submit" class="button" name="woo_wallet_transfer_fund" value="<?php _e( 'Proceed to transfer', 'shokrino' ); ?>" />
            </p>
        </form>
    </div>

    <div id="Transactions" class="tabcontent">
        <?php $transactions = get_wallet_transactions( array( 'limit' => apply_filters( 'woo_wallet_transactions_count', 10 ) ) ); ?>
            <?php if ( ! empty( $transactions ) ) { ?>
                <ul class="woo-wallet-transactions-items">
                    <?php foreach ( $transactions as $transaction ) : ?>
                        <li>
                            <div>
                                <p><?php echo $transaction->details; ?></p>
                                <small><?php echo wc_string_to_datetime( $transaction->date )->date_i18n( wc_date_format() ); ?></small>
                            </div>
                            <div class="woo-wallet-transaction-type-<?php echo $transaction->type; ?>"><?php
                                echo $transaction->type == 'credit' ? '+' : '-';
                                echo wc_price( apply_filters( 'woo_wallet_amount', $transaction->amount, $transaction->currency, $transaction->user_id ), woo_wallet_wc_price_args($transaction->user_id) );
                                ?></div>
                        </li>
                    <?php endforeach; ?>
                </ul>
                <?php
            } else {
                _e( 'No transactions found', 'shokrino' );
            }
            ?>
    </div>
</div>
