<?php
/*
Plugin Name: Panelet
Plugin URI: https://shokrino.ir/panelet
Description: The most beautiful and fastest persian WooCommerce user panel plugin
Author: Shokrino
Version: 1.1.0
Author URI: https://shokrino.ir
Textdomain: panelet
*/

defined( 'ABSPATH' ) || exit;

define('PNLT_PATH' , SHKRN_LIB.'/panelet');
define('PNLT_URL' , get_template_directory_uri().'/inc/lib/panelet');
define('PNLT_INC' , PNLT_PATH.'/inc');
define('PNLT_TPL' , PNLT_PATH.'/inc/templates');
define('PNLT_ASSETS' , get_template_directory_uri().'/inc/lib/panelet/assets');

///////////////////////////////////////////////////////////////////////////////////

if (!function_exists('is_plugin_active')) {
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');
}

include_once PNLT_INC . '/admin/optionino.php';
include_once PNLT_INC . '/core/functions.php';

///////////////////////////////////////////////////////////////////////////////////

function panelet_intercept_wc_template( $template, $template_name, $template_path ) {

    $template_directory = trailingslashit( plugin_dir_path( __FILE__ ) ) . 'woocommerce/';
    $path = $template_directory . $template_name;

    return file_exists( $path ) ? $path : $template;

}
add_filter( 'woocommerce_locate_template', 'panelet_intercept_wc_template', 10, 3 );

function panelet_custom_template( $template ) {
    if ( is_page() && is_account_page() ) {
        $template = PNLT_PATH . '/inc/templates/user-panel.php';
    }
    return $template;
}
add_filter( 'template_include', 'panelet_custom_template' );

///////////////////////////////////////////////////////////////////////////////////

