<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
$notification_panel = shkrn_options('notification_panel');
$notification_panel_text = shkrn_options('notification_panel_text');
$show_coupon_panel = shkrn_options('show_coupon_panel');
$text_coupon_panel = shkrn_options('coupon_panel_text');
$show_notifications_on_dashboard = shkrn_options('notifications_on_dashboard_enable');
$show_wallet_on_dashboard = panelet_options('wallet_on_dashboard_enable');
?>

<div class="user-panel-dashboard">
    <div class="welcome-and-discount">
        <div class="name-userpanel-welcome">
            <h3><?php
            $current_user = wp_get_current_user();
            if (!empty($current_user->display_name)) {
                echo $current_user->display_name;
            } else {
                echo _e('Site user','shokrino');
            }
            ?></h3>
        <p class="welcome-text">
            <?php _e('welcome to','shokrino') ?>&nbsp;&nbsp;<strong><?php echo get_bloginfo( 'name' ); ?></strong>&nbsp;&nbsp;<?php _e('site user panel','shokrino') ?>
        </p>
            <?php
            if ($show_coupon_panel == 'true' && !empty($text_coupon_panel)) {
            ?>
            <div class="discount-coupon">
                <div class="title-and-icon-discount">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-ticket" width="28" height="28" viewBox="0 0 24 24" stroke-width="1" stroke="#294559" fill="none" stroke-linecap="round" stroke-linejoin="round">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                    <line x1="15" y1="5" x2="15" y2="7" />
                    <line x1="15" y1="11" x2="15" y2="13" />
                    <line x1="15" y1="17" x2="15" y2="19" />
                    <path d="M5 5h14a2 2 0 0 1 2 2v3a2 2 0 0 0 0 4v3a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-3a2 2 0 0 0 0 -4v-3a2 2 0 0 1 2 -2" />
                </svg>
                <?php _e('Your Coupon:','shokrino'); ?>
                </div>
                <div class="coupon-code">
                    <?php echo $text_coupon_panel; ?>
                </div>
            </div>
            <?php } ?>
        </div>
        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="60" height="60" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><g xmlns="http://www.w3.org/2000/svg"><g><g clip-rule="evenodd" fill-rule="evenodd"><path d="m7.5 357.25v112.5c0 8.25 6.75 15 15 15h467c8.249 0 15-6.75 15-15v-112.5c0-8.249-6.75-15-15-15h-467c-8.25 0-15 6.75-15 15z" fill="#FFFFFF" data-original="#ffffff"></path><path d="m121 27.25v315h30v-285h210l-.001 285h30.001v-315z" fill="#FFF5BD" data-original="#fff5bd"></path><path d="m226 94.749v210.001l-75 37.5h210l-75.001-37.499v-210.002l75.001-37.499h-210z" fill="#C6D2DB" data-original="#c6d2db"></path><path d="m285.999 94.749v210.001l75 37.499.001-285zm-59.999 210.001v-210.001l-75-37.499v285z" fill="#FFC277" data-original="#ffc277"></path><path d="m121 319.75v22.5h30v-22.5zm239.999 0v22.5h30v-22.5z" fill="#FEE95D" data-original="#fee95d"></path><path d="m173.5 68.499-22.5-11.249v285l22.5-11.25zm165 0 22.5-11.249v285l-22.5-11.25z" fill="#F69500" data-original="#f69500"></path><path d="m7.5 357.25v112.5c0 8.249 6.75 15 15 15h22.5c-8.25 0-15-6.75-15-15v-112.5c0-8.25 6.75-15 15-15h-22.5c-8.249 0-15 6.751-15 15z" fill="#9CE4F8" data-original="#9ce4f8" class=""></path></g><g><path d="m338.5 147.25h-15v-15h15zm0-30h-15v-15h15z" fill="#FFFFFF" data-original="#ffffff"></path></g></g><g><path d="m393.69 414.433-9.57-32.437h-14.053l-11.211 62.298 14.763 2.657 5.314-29.528 8.242 27.936h13.439l7.834-28.001 5.804 29.684 14.722-2.879-12.162-62.191-14.056.053z" fill="#000000" data-original="#000000"></path><path d="m169.729 381.068v64.865h32.475v-15h-17.475v-49.865z" fill="#000000" data-original="#000000"></path><path d="m153.273 396.482v-15h-35.836v64.451h35.836v-15h-20.836v-9.725h19.3v-15h-19.3v-9.726z" fill="#000000" data-original="#000000"></path><path d="m245.635 396.047c3.498 0 6.871 1.029 9.753 2.977l6.215 4.198 8.397-12.43-6.214-4.199c-5.372-3.629-11.648-5.547-18.15-5.547-17.895 0-32.453 14.559-32.453 32.453 0 17.895 14.559 32.454 32.453 32.454 8.584 0 16.208-3.454 21.467-9.725l4.819-5.747-11.493-9.639-4.819 5.747c-2.428 2.896-5.784 4.364-9.974 4.364-9.624 0-17.453-7.83-17.453-17.454-.001-9.623 7.829-17.452 17.452-17.452z" fill="#000000" data-original="#000000"></path><path d="m72.075 382.23-13.47-.018-8.348 28.866-6.053-30.601-14.715 2.911 12.383 62.601 13.931-.095 9.523-32.93 9.522 33.022 13.922-.096 12.419-62.4-14.711-2.928-6.079 30.537z" fill="#000000" data-original="#000000"></path><path d="m282.641 413.5c0 17.895 14.559 32.453 32.453 32.453s32.453-14.559 32.453-32.453-14.559-32.453-32.453-32.453-32.453 14.558-32.453 32.453zm49.906 0c0 9.624-7.83 17.453-17.453 17.453s-17.453-7.83-17.453-17.453 7.83-17.453 17.453-17.453 17.453 7.829 17.453 17.453z" fill="#000000" data-original="#000000"></path><path d="m481.198 396.482v-15h-35.836v64.451h35.836v-15h-20.836v-9.725h19.3v-15h-19.3v-9.726z" fill="#000000" data-original="#000000"></path><path d="m437 477.25h15v15h-15z" fill="#000000" data-original="#000000"></path><path d="m489.5 334.75h-91v-315h-285v315h-91c-12.407 0-22.5 10.093-22.5 22.5v112.5c0 12.406 10.093 22.5 22.5 22.5h399.5v-15h-399.5c-4.135 0-7.5-3.364-7.5-7.5v-112.5c0-4.135 3.365-7.5 7.5-7.5h467c4.135 0 7.5 3.365 7.5 7.5v112.5c0 4.135-3.365 7.5-7.5 7.5h-22.5v15h22.5c12.407 0 22.5-10.093 22.5-22.5v-112.5c0-12.407-10.093-22.5-22.5-22.5zm-361-300h255v300h-15v-285h-225v52.499h15v-32.864l60 30v200.731l-60 29.999v-212.866h-15v217.501h-15zm54.272 30h146.457l-50.729 25.364v219.271l50.729 25.364h-146.458l50.729-25.364v-219.271zm170.728 4.635v260.729l-60-30v-200.729z" fill="#000000" data-original="#000000"></path><path d="m308.499 207.25h15v22.5h-15z" fill="#000000" data-original="#000000"></path><path d="m188.501 207.25h15v22.5h-15z" fill="#000000" data-original="#000000"></path></g></g></g></svg>
    </div>
    <div class="calendar-user-panel">
        <div class="box-days">
            <div class="day-of-week">
            <?php echo wp_date( 'l' );?>
            </div>
            <div class="date-panel">
                <?php echo wp_date( 'd F o' );?>
            </div>
        </div>
        <div class="days-of-membership">
            <?php
            $today_obj      = new DateTime( date( 'Y-m-d', strtotime( 'today' ) ) );
            $register_date  = get_the_author_meta( 'user_registered', get_current_user_id() );
            $registered_obj = new DateTime( date( 'Y-m-d', strtotime( $register_date ) ) );
            $interval_obj   = $today_obj->diff( $registered_obj );
            if( $interval_obj->days > 1 ) {
                ?>
                <p class='first-text-days'>
                    <?php _e('Registered from','shokrino'); ?>
                </p><strong><?php echo $interval_obj->days; ?></strong>
                <p class='end-text-days'>
                    <?php _e('days ago','shokrino'); ?>
                </p>
                <?php
            } elseif( 0 == $interval_obj->days ) {
                _e('Registered today','shokrino');
            } elseif( 1 == $interval_obj->days ) {
                _e('Registered yesterday','shokrino');
            } else {
                _e('Registered','shokrino');
            }
            ?>
        </div>
    </div>
    <?php
    $user_id = wp_get_current_user(  )->ID;

    $user_notif_public = get_posts( array(
        'numberposts' => -1,
        'meta_key'    => 'notif_type',
        'meta_value'  => 'public',
        'post_type'   => 'notification',
        'post_status' => 'publish',
    ) );

    $user_notif_private = get_posts( array(
        'numberposts' => -1,
        'meta_key'    => 'notif_type',
        'meta_value'  => 'private',
        'post_type'   => 'notification',
        'post_status' => 'publish',
    ) );

    if ($notification_panel == "true" or $user_notif_public or $user_notif_private) { ?>
    <div class="admin-notice-bar">
        <?php if ($notification_panel == "true" && !empty($notification_panel_text)) { ?>
        <div class="admin-message-box">
            <div class="title-notification"><?php esc_html_e('Admin Notice', 'shokrino' ); ?>  </div>
            <div class="text-notification">
                <?php echo $notification_panel_text; ?>
            </div>
        </div>
        <?php }
        if ($show_notifications_on_dashboard) :
        if ($user_notif_public) { ?>
            <div class="admin-message-box">
                <div class="title-notification notif-title">
                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="20" height="20" x="0" y="0" viewBox="0 0 512.00001 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><defs><linearGradient xmlns="http://www.w3.org/2000/svg" id="b" gradientUnits="userSpaceOnUse" x1="198.4694562602" x2="198.4694562602" xlink:href="#a" xmlns:xlink="http://www.w3.org/1999/xlink" y1="151.2006061938" y2="387.8526294488"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="d" gradientUnits="userSpaceOnUse" x1="85.966342821" x2="180.5195316846" xlink:href="#c" xmlns:xlink="http://www.w3.org/1999/xlink" y1="362.75919749" y2="391.3220834886"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="f" gradientUnits="userSpaceOnUse" x1="142.3959953034" x2="107.349881421" xlink:href="#e" xmlns:xlink="http://www.w3.org/1999/xlink" y1="395.124638848" y2="333.607310454"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="h" gradientUnits="userSpaceOnUse" x1="111.2733089892" x2="148.734558027" xlink:href="#g" xmlns:xlink="http://www.w3.org/1999/xlink" y1="359.5157262924" y2="370.8321358608"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="i" gradientUnits="userSpaceOnUse" x1="136.6075818358" x2="111.6277938474" xlink:href="#e" xmlns:xlink="http://www.w3.org/1999/xlink" y1="434.974820677" y2="378.6771839376"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="j" gradientUnits="userSpaceOnUse" x1="111.2733089892" x2="148.734558027" xlink:href="#g" xmlns:xlink="http://www.w3.org/1999/xlink" y1="405.6199406126" y2="416.936350181"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="k" gradientUnits="userSpaceOnUse" x1="117.2839907876" x2="93.4399397578" xlink:href="#e" xmlns:xlink="http://www.w3.org/1999/xlink" y1="368.5816439134" y2="242.0863675992"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="l" gradientUnits="userSpaceOnUse" x1="33.1363530618" x2="57.558863948" xlink:href="#g" xmlns:xlink="http://www.w3.org/1999/xlink" y1="196.4633330936" y2="262.4042429962"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="m" gradientUnits="userSpaceOnUse" x1="109.1977002542" x2="109.1977002542" xlink:href="#c" xmlns:xlink="http://www.w3.org/1999/xlink" y1="178.3600092364" y2="317.8091922932"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="n" gradientUnits="userSpaceOnUse" x1="333.143484324" x2="677.9598709186" xlink:href="#g" xmlns:xlink="http://www.w3.org/1999/xlink" y1="154.3509134298" y2="449.2278024876"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="o" gradientUnits="userSpaceOnUse" x1="445.1401191142" x2="255.1825159232" xlink:href="#a" xmlns:xlink="http://www.w3.org/1999/xlink" y1="217.951982327" y2="217.951982327"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="p" gradientUnits="userSpaceOnUse" x1="414.9934457684" x2="164.2522807732" y1="305.2854661276" y2="125.112287533"><stop offset="0" stop-color="#a1b5d8" stop-opacity="0"></stop><stop offset=".6699" stop-color="#8190a4" stop-opacity=".670588"></stop><stop offset="1" stop-color="#748290"></stop></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="q" gradientUnits="userSpaceOnUse" x1="180.9099569504" x2="144.1077827056" xlink:href="#a" xmlns:xlink="http://www.w3.org/1999/xlink" y1="209.51050419" y2="209.51050419"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="r" gradientUnits="userSpaceOnUse" x1="217.5385530814" x2="180.7363788366" xlink:href="#a" xmlns:xlink="http://www.w3.org/1999/xlink" y1="209.51050419" y2="209.51050419"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="s" gradientUnits="userSpaceOnUse" x1="147.4236366794" x2="121.4237635468" xlink:href="#e" xmlns:xlink="http://www.w3.org/1999/xlink" y1="236.4360937988" y2="200.8228643786"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="t" gradientUnits="userSpaceOnUse" x1="125.180038102" x2="125.180038102" xlink:href="#g" xmlns:xlink="http://www.w3.org/1999/xlink" y1="204.1757630742" y2="239.0365529554"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="u" gradientUnits="userSpaceOnUse" x1="356.544906144" x2="380.6436521852" xlink:href="#c" xmlns:xlink="http://www.w3.org/1999/xlink" y1="193.449258073" y2="258.5158523058"></linearGradient></defs><g><linearGradient xmlns="http://www.w3.org/2000/svg" id="a"><stop offset="0" stop-color="#fffcf8"></stop><stop offset=".1875" stop-color="#faf8f6"></stop><stop offset=".4041" stop-color="#eceef2"></stop><stop offset=".6353" stop-color="#d5dcea"></stop><stop offset=".875" stop-color="#b5c4df"></stop><stop offset="1" stop-color="#a1b5d8"></stop></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="b" gradientUnits="userSpaceOnUse" x1="198.4694562602" x2="198.4694562602" xlink:href="#a" xmlns:xlink="http://www.w3.org/1999/xlink" y1="151.2006061938" y2="387.8526294488"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="c"><stop offset="0" stop-color="#ff4974"></stop><stop offset=".2277" stop-color="#fd4571"></stop><stop offset=".4662" stop-color="#f93867"></stop><stop offset=".7098" stop-color="#f12358"></stop><stop offset=".9554" stop-color="#e60642"></stop><stop offset="1" stop-color="#e4003d"></stop></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="d" gradientUnits="userSpaceOnUse" x1="85.966342821" x2="180.5195316846" xlink:href="#c" xmlns:xlink="http://www.w3.org/1999/xlink" y1="362.75919749" y2="391.3220834886"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="e"><stop offset="0" stop-color="#e4003d" stop-opacity="0"></stop><stop offset=".2234" stop-color="#cd1845" stop-opacity=".223529"></stop><stop offset=".5034" stop-color="#b82e4d" stop-opacity=".501961"></stop><stop offset=".7682" stop-color="#ab3c51" stop-opacity=".768627"></stop><stop offset="1" stop-color="#a64153"></stop></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="f" gradientUnits="userSpaceOnUse" x1="142.3959953034" x2="107.349881421" xlink:href="#e" xmlns:xlink="http://www.w3.org/1999/xlink" y1="395.124638848" y2="333.607310454"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="g"><stop offset="0" stop-color="#ffd00d"></stop><stop offset=".2378" stop-color="#ffcb0e"></stop><stop offset=".5353" stop-color="#fb1"></stop><stop offset=".8632" stop-color="#ffa215"></stop><stop offset="1" stop-color="#ff9517"></stop></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="h" gradientUnits="userSpaceOnUse" x1="111.2733089892" x2="148.734558027" xlink:href="#g" xmlns:xlink="http://www.w3.org/1999/xlink" y1="359.5157262924" y2="370.8321358608"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="i" gradientUnits="userSpaceOnUse" x1="136.6075818358" x2="111.6277938474" xlink:href="#e" xmlns:xlink="http://www.w3.org/1999/xlink" y1="434.974820677" y2="378.6771839376"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="j" gradientUnits="userSpaceOnUse" x1="111.2733089892" x2="148.734558027" xlink:href="#g" xmlns:xlink="http://www.w3.org/1999/xlink" y1="405.6199406126" y2="416.936350181"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="k" gradientUnits="userSpaceOnUse" x1="117.2839907876" x2="93.4399397578" xlink:href="#e" xmlns:xlink="http://www.w3.org/1999/xlink" y1="368.5816439134" y2="242.0863675992"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="l" gradientUnits="userSpaceOnUse" x1="33.1363530618" x2="57.558863948" xlink:href="#g" xmlns:xlink="http://www.w3.org/1999/xlink" y1="196.4633330936" y2="262.4042429962"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="m" gradientUnits="userSpaceOnUse" x1="109.1977002542" x2="109.1977002542" xlink:href="#c" xmlns:xlink="http://www.w3.org/1999/xlink" y1="178.3600092364" y2="317.8091922932"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="n" gradientUnits="userSpaceOnUse" x1="333.143484324" x2="677.9598709186" xlink:href="#g" xmlns:xlink="http://www.w3.org/1999/xlink" y1="154.3509134298" y2="449.2278024876"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="o" gradientUnits="userSpaceOnUse" x1="445.1401191142" x2="255.1825159232" xlink:href="#a" xmlns:xlink="http://www.w3.org/1999/xlink" y1="217.951982327" y2="217.951982327"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="p" gradientUnits="userSpaceOnUse" x1="414.9934457684" x2="164.2522807732" y1="305.2854661276" y2="125.112287533"><stop offset="0" stop-color="#a1b5d8" stop-opacity="0"></stop><stop offset=".6699" stop-color="#8190a4" stop-opacity=".670588"></stop><stop offset="1" stop-color="#748290"></stop></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="q" gradientUnits="userSpaceOnUse" x1="180.9099569504" x2="144.1077827056" xlink:href="#a" xmlns:xlink="http://www.w3.org/1999/xlink" y1="209.51050419" y2="209.51050419"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="r" gradientUnits="userSpaceOnUse" x1="217.5385530814" x2="180.7363788366" xlink:href="#a" xmlns:xlink="http://www.w3.org/1999/xlink" y1="209.51050419" y2="209.51050419"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="s" gradientUnits="userSpaceOnUse" x1="147.4236366794" x2="121.4237635468" xlink:href="#e" xmlns:xlink="http://www.w3.org/1999/xlink" y1="236.4360937988" y2="200.8228643786"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="t" gradientUnits="userSpaceOnUse" x1="125.180038102" x2="125.180038102" xlink:href="#g" xmlns:xlink="http://www.w3.org/1999/xlink" y1="204.1757630742" y2="239.0365529554"></linearGradient><linearGradient xmlns="http://www.w3.org/2000/svg" id="u" gradientUnits="userSpaceOnUse" x1="356.544906144" x2="380.6436521852" xlink:href="#c" xmlns:xlink="http://www.w3.org/1999/xlink" y1="193.449258073" y2="258.5158523058"></linearGradient><path xmlns="http://www.w3.org/2000/svg" d="m123.101562 108.308594c-48.269531 0-87.402343 39.128906-87.402343 87.398437v43.230469c0 48.269531 39.132812 87.402344 87.402343 87.402344 76.546876 0 151.25 23.488281 214.023438 67.296875l24.113281 16.828125v-386.285156l-24.113281 16.832031c-62.773438 43.804687-137.476562 67.296875-214.023438 67.296875zm0 0" fill="url(&quot;#b&quot;)" data-original="url(#b)" class=""></path><path xmlns="http://www.w3.org/2000/svg" d="m137.625 297.253906h-78.019531l12.257812 28.886719c8.132813 19.167969 12.324219 39.777344 12.324219 60.597656v27.617188c0 21.542969 17.464844 39.007812 39.007812 39.007812 21.546876 0 39.011719-17.464843 39.011719-39.007812v-27.617188c0-20.820312-4.191406-41.429687-12.324219-60.597656zm0 0" fill="url(&quot;#d&quot;)" data-original="url(#d)"></path><path xmlns="http://www.w3.org/2000/svg" d="m132.535156 347.679688h-25.304687c-7.929688 0-14.355469 6.429687-14.355469 14.359374v.15625c0 4.316407 1.910156 8.175782 4.921875 10.808594l59.785156 59.78125c2.949219-5.488281 4.625-11.761718 4.625-18.429687v-27.617188c0-5.394531-.289062-10.773437-.847656-16.117187l-18.015625-18.015625c-2.632812-3.015625-6.492188-4.925781-10.808594-4.925781zm0 0" fill="url(&quot;#f&quot;)" data-original="url(#f)"></path><path xmlns="http://www.w3.org/2000/svg" d="m132.535156 376.554688h-25.304687c-7.929688 0-14.355469-6.429688-14.355469-14.359376v-.15625c0-7.929687 6.425781-14.359374 14.355469-14.359374h25.304687c7.929688 0 14.359375 6.429687 14.359375 14.359374v.15625c0 7.929688-6.429687 14.359376-14.359375 14.359376zm0 0" fill="url(&quot;#h&quot;)" data-original="url(#h)"></path><path xmlns="http://www.w3.org/2000/svg" d="m143.34375 398.707031c-2.632812-3.011719-6.492188-4.921875-10.808594-4.921875h-25.304687c-7.929688 0-14.359375 6.425782-14.359375 14.355469v.160156c0 4.3125 1.914062 8.171875 4.925781 10.804688l33.429687 33.429687c16.710938-3.5 29.484376-17.691406 30.847657-35.09375zm0 0" fill="url(&quot;#i&quot;)" data-original="url(#i)"></path><path xmlns="http://www.w3.org/2000/svg" d="m132.535156 422.65625h-25.304687c-7.929688 0-14.355469-6.425781-14.355469-14.355469v-.160156c0-7.929687 6.425781-14.355469 14.355469-14.355469h25.304687c7.929688 0 14.359375 6.425782 14.359375 14.355469v.160156c0 7.929688-6.429687 14.355469-14.359375 14.355469zm0 0" fill="url(&quot;#j&quot;)" data-original="url(#j)"></path><path xmlns="http://www.w3.org/2000/svg" d="m162.207031 402.359375v-15.621094c0-20.820312-4.191406-41.429687-12.324219-60.59375l-12.257812-28.890625h-78.019531l1.847656 4.355469zm0 0" fill="url(&quot;#k&quot;)" data-original="url(#k)"></path><path xmlns="http://www.w3.org/2000/svg" d="m81.726562 217.324219c0 22.566406-18.296874 40.863281-40.863281 40.863281-22.570312 0-40.863281-18.296875-40.863281-40.863281 0-22.566407 18.292969-40.863281 40.863281-40.863281 22.566407 0 40.863281 18.296874 40.863281 40.863281zm0 0" fill="url(&quot;#l&quot;)" data-original="url(#l)"></path><path xmlns="http://www.w3.org/2000/svg" d="m141.765625 244.867188v-55.089844c0-34.785156 15.949219-65.839844 40.929687-86.265625-19.617187 3.167969-39.542968 4.792969-59.59375 4.792969-48.269531 0-87.402343 39.132812-87.402343 87.402343v43.230469c0 48.269531 39.132812 87.402344 87.402343 87.402344 20.050782 0 39.976563 1.625 59.59375 4.792968-24.980468-20.421874-40.929687-51.480468-40.929687-86.265624zm0 0" fill="url(&quot;#m&quot;)" data-original="url(#m)"></path><path xmlns="http://www.w3.org/2000/svg" d="m512 217.953125c0-120.371094-46.777344-217.953125-104.484375-217.953125-57.703125 0-104.484375 97.582031-104.484375 217.953125s46.78125 217.953125 104.484375 217.953125c57.707031 0 104.484375-97.582031 104.484375-217.953125zm0 0" fill="url(&quot;#n&quot;)" data-original="url(#n)" class=""></path><path xmlns="http://www.w3.org/2000/svg" d="m482.703125 217.953125c0-96.441406-30.449219-174.621094-68.007813-174.621094-37.5625 0-68.011718 78.179688-68.011718 174.621094s30.449218 174.621094 68.011718 174.621094c37.558594 0 68.007813-78.179688 68.007813-174.621094zm0 0" fill="url(&quot;#o&quot;)" data-original="url(#o)"></path><path xmlns="http://www.w3.org/2000/svg" d="m477.71875 283.585938c-.109375.785156-.238281 1.5625-.371094 2.335937-.453125 2.800781-.941406 5.550781-1.464844 8.269531-.203124 1.09375-.40625 2.179688-.632812 3.25-1.511719 7.640625-3.25 14.945313-5.183594 21.878906-.285156 1.050782-.582031 2.085938-.878906 3.109376-.023438.109374-.058594.203124-.085938.300781-.296874 1.011719-.605468 2.023437-.914062 3.027343-.335938 1.09375-.667969 2.191407-1.027344 3.261719-.273437.871094-.546875 1.71875-.832031 2.5625-.121094.371094-.238281.726563-.371094 1.097657-.308593.90625-.621093 1.800781-.929687 2.679687-.382813 1.097656-.773438 2.195313-1.191406 3.277344-.34375.941406-.703126 1.871093-1.058594 2.789062-.191406.488281-.382813.988281-.585938 1.476563-.191406.488281-.382812.964844-.585937 1.453125-.390625.964843-.785157 1.90625-1.191407 2.851562-.238281.558594-.476562 1.105469-.726562 1.667969-.261719.605469-.523438 1.203125-.796875 1.785156-.308594.691406-.621094 1.371094-.941406 2.039063-1.597657 3.394531-3.265625 6.613281-4.992188 9.628906-10.902343 19.085937-24.070312 30.242187-38.261719 30.242187-32.210937 0-59.199218-57.519531-66.21875-134.738281-.09375-1.046875-.191406-2.097656-.273437-3.15625-.167969-1.917969-.320313-3.859375-.453125-5.816406-.023438-.296875-.035156-.59375-.058594-.894531-.121094-1.878906-.238281-3.777344-.335937-5.683594-.070313-1.226562-.128907-2.453125-.1875-3.679688-.015625-.261718-.027344-.511718-.039063-.777343l-.175781-4.429688c0-.132812 0-.265625-.015625-.382812-.046875-1.464844-.082031-2.917969-.117188-4.386719-.011718-.261719-.011718-.511719-.023437-.761719v-.109375c-.023437-1.035156-.050781-2.070312-.058594-3.109375-.015625-.726562-.027343-1.453125-.027343-2.191406-.011719-1.503906-.023438-3.003906-.023438-4.503906 0-1.503907.011719-3.003907.023438-4.503907 0-.714843.011718-1.429687.027343-2.148437.023438-1.191406.046875-2.382813.070313-3.574219 0-.25.011718-.5.011718-.75.023438-.847656.046876-1.679687.070313-2.515625.023437-1.070312.058594-2.132812.109375-3.191406.035156-1.191406.082031-2.382813.140625-3.578125.011719-.152344.011719-.320312.023437-.476562.011719-.414063.039063-.832032.058594-1.238282.238282-5.015625.574219-9.972656.992188-14.847656.117187-1.453125.25-2.894531.378906-4.335938 1.679688-.214843 3.386719-.332031 5.125-.332031 11.976562 0 22.734375 5.144531 30.207031 13.34375zm0 0" fill="url(&quot;#p&quot;)" data-original="url(#p)"></path><path xmlns="http://www.w3.org/2000/svg" d="m175.820312 237.097656h-1.621093c-6.828125 0-12.363281-5.539062-12.363281-12.367187v-30.441407c0-6.828124 5.535156-12.363281 12.363281-12.363281h1.621093c6.832032 0 12.367188 5.535157 12.367188 12.363281v30.441407c0 6.828125-5.535156 12.367187-12.367188 12.367187zm0 0" fill="url(&quot;#q&quot;)" data-original="url(#q)"></path><path xmlns="http://www.w3.org/2000/svg" d="m212.449219 237.097656h-1.621094c-6.828125 0-12.363281-5.539062-12.363281-12.367187v-30.441407c0-6.828124 5.535156-12.363281 12.363281-12.363281h1.621094c6.832031 0 12.367187 5.535157 12.367187 12.363281v30.441407c0 6.828125-5.535156 12.367187-12.367187 12.367187zm0 0" fill="url(&quot;#r&quot;)" data-original="url(#r)"></path><path xmlns="http://www.w3.org/2000/svg" d="m141.765625 244.867188v-48.769532h-22.679687c-5.792969 0-10.492188 4.699219-10.492188 10.492188v5.839844c0 3.066406 1.324219 5.8125 3.417969 7.730468l29.882812 29.882813c-.078125-1.714844-.128906-3.4375-.128906-5.175781zm0 0" fill="url(&quot;#s&quot;)" data-original="url(#s)"></path><path xmlns="http://www.w3.org/2000/svg" d="m141.765625 196.097656h-22.679687c-5.792969 0-10.492188 4.699219-10.492188 10.492188v5.839844c0 5.796874 4.699219 10.492187 10.492188 10.492187h22.679687zm0 0" fill="url(&quot;#t&quot;)" data-original="url(#t)"></path><path xmlns="http://www.w3.org/2000/svg" d="m353.722656 176.460938c-1.738281 0-3.449218.121093-5.132812.332031-1.242188 13.199219-1.90625 26.980469-1.90625 41.160156 0 13.722656.621094 27.074219 1.785156 39.886719 1.722656.21875 3.472656.34375 5.253906.34375 22.566406 0 40.863282-18.292969 40.863282-40.859375 0-22.570313-18.296876-40.863281-40.863282-40.863281zm0 0" fill="url(&quot;#u&quot;)" data-original="url(#u)"></path></g></svg>
                    <?php esc_html_e('Public Notifications', 'shokrino' ); ?>  </div>
                <div class="list-notifications">
                <?php
                    foreach ($user_notif_public as $value) {
                        ?>
                        <div class="notif-item">
                            <div class="notif-header">
                                <h3 class="notif"><?php echo $value->post_title; ?></h3>
                                <span>
                                <?php
                                $date_notif = $value->post_date;
                                echo date( 'H:i', strtotime( $date_notif ));
                                echo '&nbsp;&nbsp;&nbsp;';
                                echo date( 'Y/m/d', strtotime( $date_notif ));
                                ?>
                            </span>
                            </div>
                            <div class="notif-content">
                                <p><?php echo $value->post_content; ?></p>
                            </div>
                        </div>
                        <?php
                    }
                ?>
                </div>
                <?php
                $number_public = count($user_notif_public);
                if ($number_public >= 2) { ?>
                    <div class="fade-notifs"></div>
                    <style>
                        .fade-notifs {
                            position: absolute;
                            bottom: 21px;
                            height: 15%;
                            width: 96%;
                            border-radius: 0 0 15px 15px;
                            background: -moz-linear-gradient(top, rgba(255,255,255,0), var(--shkrn-var-color-light-dark-high));
                            pointer-events: none;
                        }
                    </style>
                <?php } ?>
            </div>
        <?php }
        endif;
        ?>
    </div>
    <?php } ?>
    <div class="informations-user-panel">
        <div class="box-count-products-orders">
            <div class="number-of-products">
                <div class="box-icon-products">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-package" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#e74c3c" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <polyline points="12 3 20 7.5 20 16.5 12 21 4 16.5 4 7.5 12 3" />
                        <line x1="12" y1="12" x2="20" y2="7.5" />
                        <line x1="12" y1="12" x2="12" y2="21" />
                        <line x1="12" y1="12" x2="4" y2="7.5" />
                        <line x1="16" y1="5.25" x2="8" y2="9.75" />
                    </svg>
                </div>
                <?php
                $count_posts = wp_count_posts( 'product' );
                echo $count_posts->publish;
                ?>
                <span class="text-number-of-products"><?php esc_html_e('Products', 'shokrino' ); ?></span>
            </div>
            <div class="number-of-bought-products">
                <div class="box-icon-bought">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-receipt" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#3498db" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <path d="M5 21v-16a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v16l-3 -2l-2 2l-2 -2l-2 2l-2 -2l-3 2m4 -14h6m-6 4h6m-2 4h2" />
                    </svg>
                </div>
                <?php
                $customer_orders = get_posts( array(
                    'numberposts' => -1,
                    'meta_key'    => '_customer_user',
                    'meta_value'  => $current_user->ID,
                    'post_type'   => wc_get_order_types(),
                    'post_status' => array('wc-completed'),
                ) );
                $product_ids = array();
                foreach ( $customer_orders as $customer_order ) {
                    $order = new WC_Order( $customer_order->ID );
                    $items = $order->get_items();
                    foreach ( $items as $item ) {
                        $product_id = $item->get_product_id();
                        $product_ids[] = $product_id;
                    }
                }
                $product_ids = array_unique( $product_ids );
                $args = array(
                    'post_type' => 'product',
                    'post__in' => $product_ids,
                );
                echo count( $product_ids );
                ?>
                <span class="text-number-of-bought-products"><?php esc_html_e('Bought products', 'shokrino' ); ?></span>
            </div>
        </div>
    </div>
    <?php if ($show_wallet_on_dashboard) { ?>
    <div class="box-wallet-count-money">
        <div class="box-icon-woo-wallet">
            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-wallet" width="44" height="44" viewBox="0 0 24 24" stroke-width="1.5" stroke="#6ab04c" fill="none" stroke-linecap="round" stroke-linejoin="round">
                <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                <path d="M17 8v-3a1 1 0 0 0 -1 -1h-10a2 2 0 0 0 0 4h12a1 1 0 0 1 1 1v3m0 4v3a1 1 0 0 1 -1 1h-12a2 2 0 0 1 -2 -2v-12" />
                <path d="M20 12v4h-4a2 2 0 0 1 0 -4h4" />
            </svg>
        </div>
        <div class="text-value-wallet-box">
        <h3 class="text-woo-wallet">
            <?php esc_html_e('Current wallet balance:', 'shokrino' ); ?>
        </h3>
        <?php
        if (is_plugin_active('woo-wallet/woo-wallet.php')) {
            $title = __('Current wallet balance', 'woo-wallet');
            $menu_item = '<a class="woo-wallet-menu-contents" href="' . esc_url(wc_get_account_endpoint_url(get_option('woocommerce_woo_wallet_endpoint', 'p-wallet'))) . '" title="' . $title . '">';
            $menu_item .= woo_wallet()->wallet->get_wallet_balance(get_current_user_id());
            $menu_item .= '</a>';
            echo $menu_item;
        } else {
            echo '<span class="wc-Symbol">';
            esc_html_e('Disable', 'shokrino');
            echo'</span>';
        }
        ?>
        </div>
    </div>
    <?php } ?>
    <a class="btn-edit-profile-user-panel" href="<?php echo esc_url(wc_get_account_endpoint_url('edit-account')); ?>">
        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-settings" width="70" height="70" viewBox="0 0 24 24" stroke-width="1.5" stroke="none" fill="#294559" stroke-linecap="round" stroke-linejoin="round">
            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
            <path d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z" />
            <circle fill="#dfe9f7" cx="12" cy="12" r="3" />
        </svg>
        <span><?php esc_html_e('Settings', 'shokrino' ); ?></span>
    </a>
    <a class="btn-back-home-user-panel" href="<?php echo site_url(); ?>">
        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-home" width="70" height="70" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
            <polyline points="5 12 3 12 12 3 21 12 19 12" />
            <path d="M5 12v7a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-7" />
            <path d="M9 21v-6a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v6" />
        </svg>
        <span><?php esc_html_e('Back to home', 'shokrino' ); ?></span>
    </a>
</div>
<?php
/**
 * My Account dashboard.
 *
 * @since 2.6.0
 */
do_action( 'woocommerce_account_dashboard' );

/**
 * Deprecated woocommerce_before_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action( 'woocommerce_before_my_account' );

/**
 * Deprecated woocommerce_after_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
